/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class RollerRenderer
extends SmartBlockEntityRenderer<RollerBlockEntity, RollerRenderState> {
    public RollerRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public RollerRenderState createRenderState() {
        return new RollerRenderState();
    }

    @Override
    public void extractRenderState(RollerBlockEntity be, RollerRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.layer = class_12249.method_75972();
        state.wheel = CachedBuffers.partial(AllPartialModels.ROLLER_WHEEL, state.field_62674);
        class_2350 facing = (class_2350)state.field_62674.method_11654((class_2769)RollerBlock.field_11177);
        state.offset = class_243.method_24954((class_2382)facing.method_62675()).method_1021(1.0625).method_1031(0.0, -0.25, 0.0);
        float angle = AngleHelper.horizontalAngle(facing);
        state.wheelAngle = AngleHelper.rad(angle);
        class_1937 world = be.method_10997();
        float time = AnimationTickHolder.getRenderTime((class_1936)world) / 20.0f;
        state.rotate = AngleHelper.rad(time * be.getAnimatedSpeed() % 360.0f);
        state.yRot = 1.5707964f;
        state.frame = CachedBuffers.partial(AllPartialModels.ROLLER_FRAME, state.field_62674);
        state.frameAngle = AngleHelper.rad(angle + 180.0f);
    }

    @Override
    public void submit(RollerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
    }

    @Environment(value=EnvType.CLIENT)
    public static class RollerRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer wheel;
        public class_243 offset;
        public float wheelAngle;
        public float rotate;
        public float yRot;
        public SuperByteBuffer frame;
        public float frameAngle;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.wheel.translate(this.offset)).rotateCentered(this.wheelAngle, class_2350.field_11036)).rotate(this.rotate, class_2350.field_11039)).translate(0.0, -0.5, 0.5)).rotateY(this.yRot)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.frame.rotateCentered(this.frameAngle, class_2350.field_11036)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

